/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.remote.common;

import com.google.common.io.ByteStreams;
import cz.insophy.inplan.remote.common.ConfPlanByteHolder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;

public class ConfPlanMessageConverter
extends AbstractHttpMessageConverter<ConfPlanByteHolder> {
    private static final Logger log = LoggerFactory.getLogger(ConfPlanMessageConverter.class);
    private static final String CONF_ENTRY_NAME = "conf.xml";
    private static final String PLAN_ENTRY_NAME = "plan.xml";

    public ConfPlanMessageConverter() {
        super(MediaType.APPLICATION_OCTET_STREAM);
    }

    public boolean supports(Class<?> clazz) {
        return ConfPlanByteHolder.class.equals(clazz);
    }

    public ConfPlanByteHolder readInternal(Class clazz, HttpInputMessage inputMessage) throws IOException {
        ZipEntry ze;
        log.info("Reading ZIP stream: " + inputMessage.getHeaders().toString());
        ByteArrayOutputStream conf = new ByteArrayOutputStream();
        ByteArrayOutputStream plan = new ByteArrayOutputStream();
        ZipInputStream zis = new ZipInputStream(inputMessage.getBody());
        while ((ze = zis.getNextEntry()) != null) {
            if (ze.getName().equals(CONF_ENTRY_NAME)) {
                log.debug("Reading configuration to byte array...");
                ByteStreams.copy(zis, conf);
                conf.close();
                continue;
            }
            if (!ze.getName().equals(PLAN_ENTRY_NAME)) continue;
            log.debug("reading plan to byte array...");
            ByteStreams.copy(zis, plan);
            plan.close();
        }
        log.debug("Reading completed.");
        return new ConfPlanByteHolder(conf.toByteArray(), plan.toByteArray());
    }

    protected void writeInternal(ConfPlanByteHolder data, HttpOutputMessage outputMessage) throws IOException {
        log.info("Writing ZIP stream: " + outputMessage.getHeaders().toString());
        ZipOutputStream zos = new ZipOutputStream(outputMessage.getBody());
        log.debug("Compressing configuration...");
        zos.putNextEntry(new ZipEntry(CONF_ENTRY_NAME));
        zos.write(data.getConf());
        zos.closeEntry();
        log.debug("Compressing plan...");
        zos.putNextEntry(new ZipEntry(PLAN_ENTRY_NAME));
        zos.write(data.getPlan());
        zos.closeEntry();
        log.debug("Finishing compression...");
        zos.finish();
        zos.flush();
        log.debug("Writing completed.");
    }

    protected Long getContentLength(ConfPlanByteHolder data, MediaType contentType) {
        return -1L;
    }
}

